#pragma once

#include <yandex/maps/wiki/validator/common.h>
#include <yandex/maps/wiki/validator/objects/adm_unit.h>

#include <maps/libs/geolib/include/direction.h>

#include <unordered_set>
#include <vector>
#include <list>

namespace maps {
namespace wiki {
namespace validator {
namespace utils {

// Represents a sector of node neighborhood formed by two adjacent
// linear elements.
struct Sector
{
    TId rightEdge;
    geolib3::Direction2 rightDirection;
    TId leftEdge;
    geolib3::Direction2 leftDirection;

    Sector complement() const
    {
        Sector ret;
        ret.rightDirection = leftDirection;
        ret.rightEdge = leftEdge;
        ret.leftDirection = rightDirection;
        ret.leftEdge = rightEdge;
        return ret;
    }
};

class NodeNeighborhood
{
public:
    struct Part
    {
        Sector sector;
        std::unordered_set<const AdmUnit*> admUnits;
    };

    void addToSector(const Sector& sector, const AdmUnit* admUnit);
    void addToAllParts(const AdmUnit* admUnit);

    std::vector<Part> parts() const;

private:
    typedef std::list<Part> TPartsList;

    // find part containing direction and split it into two,
    // returning iterator pointing to the part right after the split
    // Precondition: parts_ contains parts covering the whole circle.
    TPartsList::iterator split(const geolib3::Direction2& direction, TId edgeId);

private:
    TPartsList parts_;
    std::vector<const AdmUnit*> admUnitsInAllParts_;
};

} // namespace utils
} // namespace validator
} // namespace wiki
} // namespace maps
