#pragma once

#include <yandex/maps/wiki/validator/check_context.h>
#include <yandex/maps/wiki/validator/common.h>

#include <algorithm>
#include <vector>

namespace maps {
namespace wiki {
namespace validator {

class BuildingComplex;
class Road;
class AdmUnit;
class AdmUnitSubst;
class Face;
class LinearFeature;
class PointFeature;
class ContourFeature;
class ContourLinearFeature;
class TransportLine;

namespace utils {

inline bool objectElementsWithinAoi(CheckContext*, const BuildingComplex*);

template<class RoadCategory>
inline bool objectElementsWithinAoi(CheckContext*, const Road*);

template<class FaceCategory>
inline bool objectElementsWithinAoi(CheckContext*, const Face*);

template<class FeatureCategory>
inline bool objectElementsWithinAoi(CheckContext*, const LinearFeature*);

template<class FeatureCategory>
inline bool objectElementsWithinAoi(CheckContext*, const PointFeature*);

template<class FeatureCategory>
inline bool objectElementsWithinAoi(CheckContext*, const ContourLinearFeature*);

template<class FeatureCategory>
inline bool objectElementsWithinAoi(CheckContext*, const TransportLine*);

template<class AdmUnitCategory>
inline bool objectFacesWithinAoi(CheckContext*, const AdmUnit*);

template<class AdmUnitCategory>
inline bool objectFacesWithinAoi(CheckContext*, const AdmUnitSubst*);

template<class FeatureCategory>
inline bool objectFacesWithinAoi(CheckContext*, const ContourFeature*);

template<class FeatureCategory>
inline bool objectFacesWithinAoi(CheckContext*, const ContourLinearFeature*);

/**
 * @return List of all objects of the type Category that are not
 *   loaded into the context.
 *
 * The function emits a warning message for each not loaded object.
 *
 * @param ids List of objects identities to be filtered out.
 * @param geometry Geometry that will be shown in the validation
 *   result. A good candidate here is the ids' objects parent.
 */
template <typename Category, typename Geometry>
std::vector<TId> filterObjectsOutsideOfAoiWithWarnings(
    CheckContext* context, const std::vector<TId>& ids, const Geometry geometry)
{
    auto result = ids;

    auto it = std::remove_if(result.begin(), result.end(),
        [&](TId id) {
            if (context->objects<Category>().loaded(id)) {
                return false;
            }

            context->warning("linked-object-is-outside-of-validation-area",
                             geometry, {id});
            return true;
        });
    result.erase(it, result.end());

    return result;
}

} // namespace utils
} // namespace validator
} // namespace wiki
} // namespace maps

#define VALIDATOR_CHECKS_UTILS_OBJECT_ELEMENTS_WITHIN_AOI_INL
#include "object_elements_within_aoi-inl.h"
#undef VALIDATOR_CHECKS_UTILS_OBJECT_ELEMENTS_WITHIN_AOI_INL
