#pragma once

#include <yandex/maps/wiki/validator/common.h>
#include <maps/libs/geolib/include/polygon.h>
#include <maps/libs/geolib/include/linear_ring.h>

namespace maps {
namespace wiki {
namespace validator {

class CheckContext;

namespace utils {

void checkRingGeometry(
        const geolib3::LinearRing2& ring,
        const TId objectId,
        CheckContext* context);

void checkReducedPrecisionValidity(
        const geolib3::Polygon2& polygon,
        const TId objectId,
        CheckContext* context);

template <class TObject>
void runPolygonGeometryCheck(const TObject* object, CheckContext* context)
{
    const geolib3::Polygon2& geom = object->geom();
    const TId oid = object->id();
    checkReducedPrecisionValidity(geom, oid, context);
    checkRingGeometry(geom.exteriorRing(), oid, context);
    for (size_t idx = 0; idx < geom.interiorRingsNumber(); ++idx) {
        checkRingGeometry(geom.interiorRingAt(idx), oid, context);
    }
}

} // namespace utils
} // namespace validator
} // namespace wiki
} // namespace maps
