#pragma once

#include "category_traits.h"
#include "misc.h"
#include <yandex/maps/wiki/validator/common.h>

namespace maps {
namespace wiki {
namespace validator {
namespace utils {

template<typename ElementCategory, typename ParentCategory>
void runElementsRelationsCheck(CheckContext* context, Severity strayElementSeverity);

template<typename ElementCategory, typename LineCategory>
void runTransportElementsRelationsCheck(CheckContext* context, Severity strayElementSeverity);

// element category must be loaded
template<typename FaceCategory, typename ParentCategory>
void runFacesRelationsCheck(CheckContext* context);

// parts categories must be loaded
template<typename Category>
void runFeatureRelationsCheck(CheckContext* context);

} // namespace utils
} // namespace validator
} // namespace wiki
} // namespace maps

#define VALIDATOR_CHECKS_UTILS_RELATIONS_CHECKS_INL
#include "relations_checks-inl.h"
#undef VALIDATOR_CHECKS_UTILS_RELATIONS_CHECKS_INL
