#pragma once

#include <yandex/maps/wiki/validator/common.h>
#include <yandex/maps/wiki/validator/message.h>

#include <boost/optional.hpp>

namespace maps {

namespace geolib3 {

class Segment2;
class Polyline2;

} // namespace geolib3

namespace wiki {
namespace validator {

class CheckContext;

namespace utils {

template<class ElementCategory>
void runLinearElementsIntersectionsCheck(
    CheckContext* context,
    Severity severity);

template<class ElementCategory, class FaceCategory>
void runFaceElementsIntersectionsCheck(CheckContext* context);

enum class CheckElementsAtJunction { Yes, No };

template<class ElementCategory, class JunctionCategory>
void runJcElCoverageCheck(
        CheckContext* context,
        Severity severity,
        CheckElementsAtJunction);

template<class JunctionCategory>
void runOpenBoundsCheck(CheckContext* context);

inline bool isSegmentTooShort(const geolib3::Segment2& segment);

template<class ElementCategory>
void runSegmentsLengthCheck(CheckContext* context);

} // namespace utils
} // namespace validator
} // namespace wiki
} // namespace maps

#define VALIDATOR_CHECKS_UTILS_TOPOLOGY_CHECKS_INL
#include "topology_checks-inl.h"
#undef VALIDATOR_CHECKS_UTILS_TOPOLOGY_CHECKS_INL
