#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include "../utils/names.h"

#include <functional>

using maps::wiki::validator::categories::VEGETATION;
using maps::wiki::validator::categories::VEGETATION_NM;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_SIMPLE_CHECK( vegetation_naming, VEGETATION, VEGETATION_NM )
{
    context->objects<VEGETATION>().visit([&](const ContourFeature* vegetation)
    { utils::runBasicNamesCheck<VEGETATION_NM>(vegetation, context); });
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
