#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include "../utils/relations_checks.h"

using maps::wiki::validator::categories::VEGETATION;
using maps::wiki::validator::categories::VEGETATION_FC;
using maps::wiki::validator::categories::VEGETATION_EL;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_CHECK_PART(
        vegetation_relations, face_elements_relations, VEGETATION_EL, VEGETATION_FC )
{
    utils::runElementsRelationsCheck<VEGETATION_EL, VEGETATION_FC>(
            context, Severity::Fatal);
}

VALIDATOR_CHECK_PART(
        vegetation_relations, faces_relations, VEGETATION_FC, VEGETATION_EL, VEGETATION )
{
    utils::runFacesRelationsCheck<VEGETATION_FC, VEGETATION>(context);
}

VALIDATOR_CHECK_PART(
        vegetation_relations, compound_objects_relations, VEGETATION, VEGETATION_FC )
{
    utils::runFeatureRelationsCheck<VEGETATION>(context);
}

} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
