#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include "../utils/topology_checks.h"

using maps::wiki::validator::categories::VEGETATION_FC;
using maps::wiki::validator::categories::VEGETATION_EL;
using maps::wiki::validator::categories::VEGETATION_JC;

namespace maps {
namespace wiki {
namespace validator {
namespace checks {

VALIDATOR_CHECK_PART( vegetation_topology, segments_length, VEGETATION_EL )
{
    utils::runSegmentsLengthCheck<VEGETATION_EL>(context);
}

VALIDATOR_CHECK_PART( vegetation_topology, intersections,
        VEGETATION_FC, VEGETATION_EL )
{
    utils::runFaceElementsIntersectionsCheck<VEGETATION_EL, VEGETATION_FC>(
            context);
}

VALIDATOR_CHECK_PART( vegetation_topology, jc_el_coverage,
        VEGETATION_EL, VEGETATION_JC )
{
    utils::runJcElCoverageCheck<VEGETATION_EL, VEGETATION_JC>(
            context, Severity::Error, utils::CheckElementsAtJunction::No);
}

VALIDATOR_CHECK_PART( vegetation_topology, open_bounds, VEGETATION_JC )
{
    utils::runOpenBoundsCheck<VEGETATION_JC>(context);
}


} // namespace checks
} // namespace validator
} // namespace wiki
} // namespace maps
