#include "module.h"
#include <yandex/maps/wiki/validator/check.h>
#include <yandex/maps/wiki/validator/categories.h>

#include <unordered_set>

using maps::wiki::validator::categories::VEGETATION;
using maps::wiki::validator::categories::VEGETATION_CNT;
using maps::wiki::validator::categories::VEGETATION_NM;

namespace maps::wiki::validator::checks {

VALIDATOR_SIMPLE_CHECK(vegetation_with_name_cnt,
        VEGETATION, VEGETATION_NM, VEGETATION_CNT )
{
    std::unordered_set<TId> vegetationIds;
    context->objects<VEGETATION>().visit([&](const ContourFeature* vegetation) {
        if (!vegetation->names().empty()) {
            vegetationIds.insert(vegetation->id());
        }
    });
    context->objects<VEGETATION_CNT>().visit([&](const Center* center) {
        vegetationIds.erase(center->parent());
    });
    for (const auto vegId : vegetationIds) {
        context->report(
                Severity::Critical,
                "named-vegetation-without-cnt",
                boost::none,
                {vegId});
    }
}

} // namespace maps::wiki::validator::checks
