#include "module.h"

#include "vehicle_restrictions_common.h"

#include <yandex/maps/wiki/validator/categories.h>
#include <yandex/maps/wiki/validator/check.h>

namespace maps::wiki::validator::checks {

using categories::VEHICLE_RESTRICTION;

VALIDATOR_SIMPLE_CHECK( vehicle_restriction, VEHICLE_RESTRICTION )
{
    context->objects<VEHICLE_RESTRICTION>().visit([&](const VehicleRestriction* vrObject) {
        checkVehicleRestriction(
            vrObject->vehicleRestrictionParameters(),
            {},
            boost::none,
            {vrObject->id()},
            *context);
    });

}

} // namespace maps::wiki::validator::checks
