#include "vehicle_restrictions_common.h"

using namespace std::string_literals;

namespace maps::wiki::validator::checks {

void
checkVehicleRestriction(
        const std::unique_ptr<VehicleRestrictionParameters>& vrParams,
        const std::string& prefix,
        const boost::optional<geolib3::Point2>& geom,
        const std::vector<TId>& oids,
        CheckContext& context)
{
    if (!vrParams) {
        return;
    }
    auto checkRange = [&](
        const std::optional<double>& value,
        const std::string& name,
        const double minValue,
        const double maxValue)
    {
        if (!value) {
            return;
        }
        if (*value > maxValue ||
            *value < minValue)
        {
            context.report(
                Severity::Critical,
                prefix + "vehicle-restriction-" + name + "-out-off-range",
                geom,
                oids);
        }
    };

    checkRange(vrParams->weightLimit, "weight-limit"s, 1.5, 80.);
    checkRange(vrParams->axleWeightLimit, "axle-weight-limit"s, 1.5, 18.);
    checkRange(vrParams->maxWeightLimit, "max-weight-limit"s, 2., 34.);
    checkRange(vrParams->payloadLimit, "payload-limit"s, 1., 34.);
    checkRange(vrParams->heightLimit, "height-limit"s, 1.3, 10.);
    checkRange(vrParams->lengthLimit, "length-limit"s, 4.3, 20.);
    checkRange(vrParams->widthLimit, "width-limit"s, 1.7, 15.);
}

} // namespace maps::wiki::validator::checks
