OWNER(g:maps-nmaps)

LIBRARY()

PEERDIR(
    contrib/restricted/boost/libs
    contrib/libs/geos
    contrib/libs/icu
    library/cpp/resource
    maps/libs/common
    maps/libs/geolib
    maps/libs/json
    maps/libs/locale
    maps/libs/ymapsdf
    maps/wikimap/mapspro/libs/flat_range
    maps/wikimap/mapspro/libs/geom_tools
    maps/wikimap/mapspro/libs/graph
    maps/wikimap/mapspro/libs/poi_conflicts
    maps/wikimap/mapspro/libs/routing
    maps/wikimap/mapspro/libs/validator
)

SRCS(
    GLOBAL base_only_check.cpp

    GLOBAL addr/addr_geometry_check.cpp
    GLOBAL addr/addr_naming_check.cpp
    GLOBAL addr/addr_relations_check.cpp
    GLOBAL addr/addr_uniqueness_check.cpp
    GLOBAL addr/addr_unity_check.cpp
    GLOBAL addr/arrival_point_uniqueness_check.cpp
    GLOBAL addr/flat_range_check.cpp

    GLOBAL adm-unit/ad_address_check.cpp
    GLOBAL adm-unit/ad_fc_validity_check.cpp
    GLOBAL adm-unit/ad_geometry_check.cpp
    GLOBAL adm-unit/ad_hierarchy_check.cpp
    GLOBAL adm-unit/ad_hierarchy_geom_check.cpp
    GLOBAL adm-unit/ad_naming_check.cpp
    GLOBAL adm-unit/ad_relations_check.cpp
    GLOBAL adm-unit/ad_topology_check.cpp

    GLOBAL ad-neutral/ad_neutral_fc_validity_check.cpp
    GLOBAL ad-neutral/ad_neutral_geometry_check.cpp
    GLOBAL ad-neutral/ad_neutral_naming_check.cpp
    GLOBAL ad-neutral/ad_neutral_relations_check.cpp
    GLOBAL ad-neutral/ad_neutral_topology_check.cpp

    GLOBAL bld/bld_complex_check.cpp
    GLOBAL bld/bld_el_intersections_check.cpp
    GLOBAL bld/bld_geometry_check.cpp
    GLOBAL bld/bld_height_check.cpp
    GLOBAL bld/bld_urban_relations_check.cpp

    GLOBAL condition/cond_cam_logic_check.cpp
    GLOBAL condition/conditions_duplicates_check.cpp
    GLOBAL condition/conditions_logic_check.cpp
    GLOBAL condition/conditions_relations_check.cpp
    GLOBAL condition/conditions_schedules_check.cpp
    GLOBAL condition/conditions_topo_check.cpp
    GLOBAL condition/cond_ds_el_check.cpp
    GLOBAL condition/cond_ds_topo_check.cpp
    GLOBAL condition/cond_lane_duplicates_check.cpp
    GLOBAL condition/cond_lane_logic_check.cpp
    GLOBAL condition/cond_lane_topo_check.cpp
    GLOBAL condition/cond_toll_checks.cpp
    GLOBAL condition/cond_annotation_checks.cpp
    GLOBAL condition/cond_ds_logic_check.cpp
    GLOBAL condition/cond_vehicle_restrictions_check.cpp
    GLOBAL condition/traffic_lights_check.cpp

    connectivity/component_report.cpp
    connectivity/road_network.cpp
    GLOBAL connectivity/strong_connectivity_bicycle_check.cpp
    GLOBAL connectivity/strong_connectivity_by_fc_check.cpp
    GLOBAL connectivity/strong_connectivity_check.cpp
    GLOBAL connectivity/strong_connectivity_checks_common.cpp
    GLOBAL connectivity/strong_connectivity_moto_check.cpp
    GLOBAL connectivity/strong_connectivity_pedestrian_check.cpp
    GLOBAL connectivity/strong_connectivity_scooter_check.cpp
    GLOBAL connectivity/strong_connectivity_taxi_check.cpp
    GLOBAL connectivity/strong_connectivity_truck_check.cpp

    GLOBAL geocoder-requirements/geobase_id_check.cpp

    GLOBAL hd-map/road_marking_spatial_relation_check.cpp

    GLOBAL hydro/flooding_check.cpp
    GLOBAL hydro/hydro_fc_validity_check.cpp
    GLOBAL hydro/hydro_geometry_check.cpp
    GLOBAL hydro/hydro_naming_check.cpp
    GLOBAL hydro/hydro_relations_check.cpp
    GLOBAL hydro/hydro_relief_intersections_check.cpp
    GLOBAL hydro/hydro_topology_check.cpp

    GLOBAL indoor/indoor_attributes_checks.cpp
    GLOBAL indoor/indoor_geometry_check.cpp
    GLOBAL indoor/indoor_naming_check.cpp
    indoor/indoor_common.cpp

    GLOBAL local-names/local_names_check.cpp
    GLOBAL local-names/local_ukr_names_check.cpp

    GLOBAL poi/poi_business_id_check.cpp
    GLOBAL poi/poi_conflicts_check.cpp
    GLOBAL poi/poi_entrance_geometry_check.cpp
    GLOBAL poi/poi_geometry_check.cpp
    GLOBAL poi/poi_position_quality.cpp
    GLOBAL poi/poi_naming_check.cpp
    GLOBAL poi/poi_relations_check.cpp
    GLOBAL poi/poi_uniqueness_check.cpp

    GLOBAL region/region_geometry_check.cpp
    GLOBAL region/region_naming_check.cpp
    GLOBAL region/region_relations_check.cpp

    GLOBAL rd/rd_ad_inclusion_check.cpp
    GLOBAL rd/rd_ad_relations_check.cpp
    GLOBAL rd/rd_ad_uniqueness_check.cpp
    GLOBAL rd/rd_rd_el_relations_check.cpp
    GLOBAL rd/road_gaps_check.cpp
    GLOBAL rd/road_naming_check.cpp

    GLOBAL relief/relief_fc_validity_check.cpp
    GLOBAL relief/relief_geometry_check.cpp
    GLOBAL relief/relief_naming_check.cpp
    GLOBAL relief/relief_relations_check.cpp
    GLOBAL relief/relief_topology_check.cpp

    GLOBAL road-graph/dead_ends_check.cpp
    GLOBAL road-graph/length_check.cpp
    GLOBAL road-graph/linked_attributes_check.cpp
    GLOBAL road-graph/rd_el_pedestrian_crossing.cpp
    GLOBAL road-graph/rd_topology_check.cpp
    GLOBAL road-graph/uc_open_at_check.cpp
    GLOBAL road-graph/wrong_oneways_check.cpp
    GLOBAL road-graph/zlevels_check.cpp

    splitter/checks_splitter.cpp

    GLOBAL transport/transport_import_source_check.cpp
    GLOBAL transport/transport_naming_check.cpp
    GLOBAL transport/transport_tram_topology_check.cpp

    GLOBAL transport-airport/transport_airport_geometry_check.cpp
    GLOBAL transport-airport/transport_airport_import_source_check.cpp
    GLOBAL transport-airport/transport_airport_naming_check.cpp
    GLOBAL transport-airport/transport_airport_relations_check.cpp

    GLOBAL transport-metro/transport_metro_boarding_check.cpp
    GLOBAL transport-metro/transport_metro_exit_check.cpp
    GLOBAL transport-metro/transport_metro_geometry_check.cpp
    GLOBAL transport-metro/transport_metro_import_source_check.cpp
    GLOBAL transport-metro/transport_metro_naming_check.cpp
    GLOBAL transport-metro/transport_metro_relations_check.cpp
    GLOBAL transport-metro/transport_metro_topology_check.cpp

    GLOBAL transport-metro-threads/duplicates_check.cpp
    GLOBAL transport-metro-threads/transport_metro_thread_import_source_check.cpp
    GLOBAL transport-metro-threads/transport_metro_thread_time_check.cpp
    GLOBAL transport-metro-threads/transport_thread_relations_check.cpp
    GLOBAL transport-metro-threads/transport_thread_station_distance_check.cpp
    GLOBAL transport-metro-threads/transport_thread_topology_validity_check.cpp

    GLOBAL transport-railway/transport_railway_geometry_check.cpp
    GLOBAL transport-railway/transport_railway_import_source_check.cpp
    GLOBAL transport-railway/transport_railway_naming_check.cpp
    GLOBAL transport-railway/transport_railway_relations_check.cpp
    GLOBAL transport-railway/transport_railway_topology_check.cpp

    GLOBAL transport-thread/transport_route_relations_check.cpp
    GLOBAL transport-thread/transport_thread_attributes_check.cpp
    GLOBAL transport-thread/transport_thread_import_source_check.cpp
    GLOBAL transport-thread/transport_thread_relations_check.cpp
    GLOBAL transport-thread/transport_thread_time_check.cpp
    GLOBAL transport-thread/transport_thread_topology_validity_check.cpp

    transport-thread-common/common.cpp

    GLOBAL transport-waterway/transport_waterway_import_source_check.cpp
    GLOBAL transport-waterway/transport_waterway_naming_check.cpp
    GLOBAL transport-waterway/transport_waterway_relations_check.cpp
    GLOBAL transport-waterway/transport_waterway_topology_check.cpp

    GLOBAL urban/urban_fc_validity_check.cpp
    GLOBAL urban/urban_geometry_check.cpp
    GLOBAL urban/urban_naming_check.cpp
    GLOBAL urban/urban_relations_check.cpp
    GLOBAL urban/urban_topology_check.cpp

    GLOBAL urban-roadnet/urban_roadnet_fc_validity_check.cpp
    GLOBAL urban-roadnet/urban_roadnet_geometry_check.cpp
    GLOBAL urban-roadnet/urban_roadnet_naming_check.cpp
    GLOBAL urban-roadnet/urban_roadnet_parking_check.cpp
    GLOBAL urban-roadnet/urban_roadnet_relations_check.cpp
    GLOBAL urban-roadnet/urban_roadnet_topology_check.cpp

    utils/disjoint_sets.cpp
    utils/face_builder.cpp
    utils/face_checks.cpp
    utils/find_gaps_representatives.cpp
    utils/geom.cpp
    utils/names.cpp
    utils/node_neighborhood.cpp
    utils/polygon_checks.cpp
    utils/road_utils.cpp
    utils/topology_checks.cpp

    GLOBAL vegetation/vegetation_cnt_check.cpp
    GLOBAL vegetation/vegetation_fc_validity_check.cpp
    GLOBAL vegetation/vegetation_geometry_check.cpp
    GLOBAL vegetation/vegetation_naming_check.cpp
    GLOBAL vegetation/vegetation_relations_check.cpp
    GLOBAL vegetation/vegetation_topology_check.cpp
    GLOBAL vegetation/vegetation_with_name_cnt_check.cpp

    GLOBAL vehicle_restrictions/vehicle_restrictions_check.cpp
    GLOBAL vehicle_restrictions/vehicle_restrictions_direction_check.cpp
    vehicle_restrictions/vehicle_restrictions_common.cpp

    GLOBAL service-objects/mrc_pedestrian_region_check.cpp
)

RESOURCE(
    geocoder-requirements/geobase_id_check_data/geobase_id_map.json geobase_id_map.json
)

END()

RECURSE(
    tests
)
