#pragma once

#include <maps/wikimap/mapspro/services/tasks_export/src/export_worker/lib/export_helpers.h>

#include <maps/libs/http/include/client.h>
#include <maps/libs/json/include/value.h>

namespace maps::wiki::exporter {

class GardenPoster {
public:
    GardenPoster(std::string gardenContour, std::string gardenOauth);

    void postToGarden(const Dataset& dataset, const std::string& nmapsBranchId);

private:
    std::string generateCreateBuildJson(const Dataset& dataset, const std::string& nmapsBranchId);
    std::string generateStartBuildJson(std::string_view buildVersion);
    std::string getModuleLastBuildVersion(const std::string& moduleName);
    maps::json::Value createBuild(const Dataset& dataset, const std::string& nmapsBranchId);
    void waitUntilBuildCreated(const std::string& buildId);
    void startBuild(const std::string& buildVersion);

    const std::string contour_;
    const std::string oauthToken_;
    maps::http::Client http_;
};

} // namespace maps::wiki::export::dev
