#pragma once

#include "config.h"
#include "export_files.h"
#include "export_helpers.h"

#include <yandex/maps/wiki/threadutils/threadpool.h>

#include <atomic>

namespace maps::wiki::exporter {

class DatasetMaker {
public:
    DatasetMaker(
        const ExportConfig& exportCfg,
        const ExportFiles& exportFiles);

    void make(const Region& region);
    void cancel();

    Datasets datasets();

private:
    void safeMake(const Region& region);

    const ExportConfig& exportCfg_;
    const ExportFiles& exportFiles_;
    Datasets datasets_;
    std::atomic<bool> fail_;
    ThreadPool pool_;
};

} // namespace maps::wiki::exporter
