#pragma once
#include "config.h"

#include <maps/libs/common/include/temporary_dir.h>
#include <yandex/maps/wiki/common/extended_xml_doc.h>

#include <filesystem>
#include <string>

namespace maps::wiki::exporter {

enum class TmpFile {
    DUMP_DIR,
    JSON2YMAPSDF_LOG,
    JSON_DIR,
    JSON_LIST_FILE,
    OBJECT_IDS_DUMP_FILE,
    PRINTED_CFG,
    SERVICE_JSON_FILE,
    SERVICE_SHAPE_DIR,
    SERVICE_GEOJSON_DIR
};


enum class ResultFile {
    DUMP_TAR_GZ,
    DUMP_GZ_TAR,
    JSON2YMAPSDF_LOG,
    OBJECT_IDS_ARCHIVE,
    SERVICE_SHAPE_ARCHIVE,
    SERVICE_GEOJSON_ARCHIVE
};


class ExportFiles {
public:
    ExportFiles(
        const std::string& rootDir,
        const ExportConfig& cfg
    );

    std::string operator()(TmpFile file) const;
    std::string operator()(ResultFile file, const Region& region) const;

    std::string ymapsdfSchemasArchive() const;
    std::string jsonBackupFile() const;

    static void cleanupOldDirs(const std::string& rootDir, Subset subset);


private:
    Subset subset_;

    std::filesystem::path resultDirectoryFor(const Region& region) const;

    /*
     * Work directory nested under rootDir.
     * This folder is being created for each task.
     * These folders can be rotated using cleanupOldDirs() method.
     */
    std::filesystem::path workDir_;

    //Result folder will be nested under workDir_.
    std::filesystem::path resultDir_;

    /**
     * Temporary directory and a bunch of nested subfolders for convenient path generation.
     * NB: this directory will be deleted upon task finish.
     */
    maps::common::TemporaryDir tempDir_;
    std::filesystem::path dumpDir_;
    std::filesystem::path jsonDir_;
    std::filesystem::path serviceShapeDir_;
    std::filesystem::path serviceGeojsonDir_;

    friend std::ostream& operator<<(std::ostream& out, const ExportFiles& exportFiles);
};

std::ostream& operator<<(std::ostream& out, const ExportFiles& exportFiles);

extern const std::string GZ_SUFFIX;

std::vector<std::string> resultFiles(
    const ExportFiles& exportFiles,
    Subset subset,
    Region region);

} // namespace maps::wiki::exporter
