#pragma once

#include "config.h"
#include "task_params.h"
#include "export_files.h"

#include <yandex/maps/wiki/mds_dataset/dataset_gateway.h>
#include <yandex/maps/wiki/mds_dataset/export_metadata.h>

#include <map>
#include <vector>

namespace maps::wiki::exporter {

using Dataset = mds_dataset::Dataset<mds_dataset::ExportMetadata>;
using Datasets = std::vector<Dataset>;

Dataset publishMdsDataset(
    const ExportConfig& exportCfg,
    const Region& region,
    IsTested tested,
    mds_dataset::DatasetStatus status,
    const std::vector<std::string>& files);

Dataset publishMdsErrorDataset(
    const ExportConfig& exportCfg,
    const std::vector<std::string>& files);

std::optional<Dataset> makeDataset(
    const ExportConfig& exportCfg,
    const ExportFiles& exportFiles,
    const Region& region=NO_REGION);

void saveResult(
    const ExportConfig& exportCfg,
    pgpool3::Pool& dbPool,
    const Datasets& datasets);

std::string files(const Dataset& dataset);

/*
 * Puts flat directory pointed by source into tar archive pointed by output.
 * Will throw if directory contains any non-regular files.
 */
void tar(const std::string& source, const std::string& output);

/*
 * Puts flat directory pointed by source into tar.gz archive pointed by output.
 * Will throw if directory contains any non-regular files.
 */
void tarGz(const std::string& source, const std::string& output);

/*
 * Puts flat directory pointed by source into gz.tar archive pointed by output.
 * Will throw if directory contains any non-regular files.
 */
void gzTar(const std::string& source, const std::string& output);

void gzipFile(const std::string& source, const std::string& output);

void copySingleFile(const std::string& source, const std::string& output);

} // namespace maps::wiki::exporter

