#pragma once

#include "export_files.h"
#include "export_helpers.h"

namespace maps::wiki::exporter {

class ExportViaYmapsdf {
public:
    ExportViaYmapsdf(
        const ExportConfig& exportCfg,
        const ExportFiles& exportFiles);

    virtual ~ExportViaYmapsdf() { }

    Datasets run(ResultFile dumpResultFile);

protected:
    virtual void ymapsdf2Dump(const std::string& schema) = 0;

    void checkCanceled() const;
    const ExportConfig& exportCfg() const { return exportCfg_; }
    const ExportFiles& exportFiles_;

private:
    bool processRegion(ResultFile dumpResultFile, const Region& region);

    const ExportConfig& exportCfg_;
};

} // namespace maps::wiki::exporter

