#pragma once

#include "config.h"
#include <maps/libs/common/include/exception.h>

#include <string>

namespace maps::wiki::exporter {

class Json2ShapeError : public maps::Exception {
    using maps::Exception::Exception;
};

class ConvertFromShapeError : public maps::Exception {
    using maps::Exception::Exception;
};


void json2Shape(
    const std::string& inputFile,
    const std::string& outputDir,
    const CategoriesMap& categoriesMap,
    const CategoriesFiltersMap& categoriesFilters={});


void convertFromShape(
    const std::string& inputDir,
    const std::string& outputDir,
    const std::string& gdalDriverName="Geojson");

} // namespace maps::wiki::exporter
