#pragma once

#include "db_log.h"

#include <yandex/maps/wiki/common/extended_xml_doc.h>
#include <yandex/maps/wiki/tasks/task_logger.h>
#include <yandex/maps/wiki/revision/common.h>

#include <chrono>
#include <filesystem>
#include <ostream>

namespace fs = std::filesystem;

namespace maps::wiki::exporter {

class FormattedDuration {
public:
    template <class Duration>
    FormattedDuration(Duration duration)
        : millis_(std::chrono::duration_cast<std::chrono::milliseconds>(duration))
    {}

    void printTo(std::ostream& os) const;

private:
    std::chrono::milliseconds millis_;
};

inline std::ostream& operator<<(std::ostream& os, const FormattedDuration& d)
{
    d.printTo(os);
    return os;
}

/// @brief: Removes directories within \p baseDir
/// whose names matche the \p pattern
/// starting from the lexicographically smallest and keeping \p numDirsToKeep
void cleanupOldDirs(
    const std::string& baseDir,
    const std::string& prefix,
    size_t numDirsToKeep);

} // namespace maps::wiki::exporter
