#pragma once

#include "db_log.h"

#include <chrono>
#include <memory>
#include <string>

namespace maps::wiki::exporter {

class ExportError : public maps::Exception {
    using maps::Exception::Exception;
};


enum class LogTaskMode {
    None,
    OnStart,
    OnFinish,
    OnStartFinish
};


/**
 * Represents a task that logs start/end of execution
 * and measures execution time.
 * @throws any exception that can be thrown by the passed function \p fun
 */
class MeasurableTask {
public:
    using Functor = std::function<void()>;
    using Clock = std::chrono::high_resolution_clock;

    MeasurableTask(
        Functor fun,
        Logger& dbLogger,
        std::string label,
        LogTaskMode logMode = LogTaskMode::OnStartFinish);

    void operator()();

    const Clock::duration& duration() const { return duration_; }

    const std::string& label() const { return label_; }

private:
    Functor fun_;
    Logger& dbLogger_;
    std::string label_;
    Clock::duration duration_;
    LogTaskMode logMode_;
};


void runMeasurable(
    MeasurableTask::Functor fun,
    Logger& dbLogger,
    std::string label,
    LogTaskMode logMode = LogTaskMode::OnStartFinish);

} // maps::wiki::exporter
