#pragma once

#include <maps/libs/pgpool/include/pgpool3.h>
#include <yandex/maps/wiki/revision/branch_manager.h>

#include <memory>
#include <vector>

namespace maps::wiki::exporter {


std::unique_ptr<pgpool3::Pool> createPgPool(
    const std::string& connectionString);


std::vector<std::string> getSchemasByPattern(
    pgpool3::Pool& pool,
    const std::string& sqlLikePattern);

bool dropSchema(
    pgpool3::Pool& pool,
    const std::string& schema);


bool renameSchema(
    pgpool3::Pool& pool,
    const std::string& schema,
    const std::string& newSchema);

bool schemaExists(
    pgpool3::Pool& pool,
    const std::string& schema);

std::vector<std::string> getSchemaTables(
    pgpool3::Pool& pool,
    const std::string& schema);


revision::Branch loadBranchByString(
    pgpool3::Pool& pool,
    const std::string& branch);

} // namespace maps::wiki::exporter
