#pragma once

#include <maps/libs/common/include/exception.h>
#include <maps/tools/grinder/worker/include/api.h>
#include <yandex/maps/wiki/mds_dataset/types.h>
#include <yandex/maps/wiki/revision/common.h>

#include <string>

namespace maps::wiki::exporter {

// Tag format: <date>_<taskId>_<branchId>_<commitId>
// Example:    20150730_001234_56_789
// Note: keep the following two patterns consistent.
const std::string TASK_TAG_RE = "(\\d{8})_\\d{6,}_.+_\\d+";
const std::string TASK_TAG_PATTERN = "_%06ld_%s_%ld";

const std::string DATE_FORMAT = "%Y%m%d";

using mds_dataset::Subset;
using mds_dataset::IsTested;

Subset subsetFromString(const std::string& str);


struct TaskParams {
    const grinder::worker::Task* grinderTask;
    uint64_t taskId;
    revision::DBID commitId;
    std::string branch;
    Subset subset;
    std::string experiment;
    IsTested tested;

    TaskParams(const grinder::worker::Task& task);

    TaskParams(
        uint64_t taskId_,
        revision::DBID commitId_,
        const std::string& branch_,
        Subset subset_,
        const std::string& experiment_,
        IsTested tested_);
};

std::string makeTaskTag(const TaskParams& taskParams);

class ExportCanceledException: public maps::Exception {
    using maps::Exception::Exception;
};

void checkCanceled(const TaskParams& taskParams);

} // namespace maps::wiki::exporter
