#!/bin/bash

MDS_PORT=`(netstat -an | grep tcp | awk '{ print $4; }' | sed 's/.*://; p'; seq 28000 30000) | sort -n | uniq -u | head -1`

TEST_CONFIG_TEMPLATE=tests/services.local.export-tests.tmpl
TEST_CONFIG_FILE=tests/services.local.export-tests.xml

# Prepare config file with the correct MDS port numbers
sed -e "s/@MDS_READ_PORT_PLACEHOLDER@/$MDS_PORT/"  \
    -e "s/@MDS_WRITE_PORT_PLACEHOLDER@/$MDS_PORT/" \
    $TEST_CONFIG_TEMPLATE > $TEST_CONFIG_FILE

# Start fake MDS server
python tests/test_mds_server.py $MDS_PORT &
trap "kill $!; rm $TEST_CONFIG_FILE" EXIT
sleep 1

# Run tests
set -e
tests/export-tests
