#pragma once

#include <yandex/maps/wiki/common/extended_xml_doc.h>
#include <yandex/maps/wiki/tasks/task_logger.h>
#include <yandex/maps/wiki/tasks/task_manager.h>
#include <yandex/maps/wiki/tasks/tasks.h>

#include <maps/libs/log8/include/log8.h>
#include <maps/libs/pgpool/include/pgpool3.h>

#define DUAL_INFO(message) \
    INFO() << message; \
    logger.logInfo() << message;

#define DUAL_WARN(message) \
    WARN() << message; \
    logger.logWarn() << message;

#define DUAL_ERROR(message) \
    ERROR() << message; \
    logger.logError() << message;

namespace maps::wiki::validation_export {

struct ValidationParam
{
    tasks::ObjectId aoiId;
    tasks::ObjectId regionId;
    tasks::PresetId presetId;
};

using ValidationParams = std::vector<ValidationParam>;

enum class TaskStatus
{
    Success,
    Failed,
    Unknown
};

std::ostream& operator<<(std::ostream& stream, TaskStatus status);

enum class TaskResult
{
    ValidatedAndExported,
    FatalErrorsFound
};

struct StartedTasks
{
    tasks::TaskInfo exportTask;
    tasks::TaskInfos validationTasks;
};

struct ValidationResult
{
    std::set<tasks::ObjectId> objectIdsWithFatalMessages;
    std::vector<std::string> fatalMessagesLinks;
    std::set<tasks::TaskId> failedTaskIds;
};

struct RuntimeData
{
    StartedTasks runTasks();

    ValidationResult waitForValidation(
        tasks::TaskInfos currentValidationTasks);

    TaskStatus waitForExport(const tasks::TaskInfo& exportTask);

    TaskResult checkExport(
        const tasks::TaskInfo& exportTask,
        const std::set<tasks::ObjectId>& objectIdsWithFatalMessages);

    pgpool3::Pool& coreDbPool;
    pgpool3::Pool& validatorDbPool;
    const ValidationParams& validationParams;

    tasks::BranchId branchId;
    tasks::CommitId commitId;
    tasks::TaskPgLogger& logger;
    tasks::TaskManager& taskManager;
    tasks::TaskManager::CheckCancelCallback checkCancel;

    const std::string& nproHost;

private:
    std::set<tasks::ObjectId> findObjectIdsWithFatalMessages(
        const tasks::TaskInfo& task);

    tasks::TaskInfos findChildTasks(tasks::TaskId parentTaskId);

    std::string nproFatalMessagesLink(tasks::TaskId taskId) const;

    TaskResult checkValidationResult(
        tasks::TaskId exportTaskId,
        const std::set<tasks::ObjectId>& objectIdsWithFatalMessages);
};

} // namespace maps::wiki::validation_export
