#pragma once

#include "runtime_data.h"

#include <yandex/maps/wiki/common/extended_xml_doc.h>
#include <yandex/maps/wiki/common/pgpool3_helpers.h>

#include <maps/tools/grinder/worker/include/api.h>
#include <maps/libs/st/include/st.h>

namespace maps::wiki::validation_export {

const std::string TASK_NAME = "validation_export";

struct StarTrackIssueData
{
    tasks::BranchId branchId;
    tasks::TaskId thisTaskId;
    TaskStatus thisTaskStatus;
    tasks::TaskId exportTaskId;
    TaskStatus exportTaskStatus;
    ValidationResult validationResult;

    StarTrackIssueData(tasks::BranchId branchId, tasks::TaskId thisTaskId);
};

class Worker
{
public:
    explicit Worker(const common::ExtendedXmlDoc& configXml);

    void run(const maps::grinder::worker::Task& grinderTask) const;

private:
    void createIssue(
        tasks::TaskPgLogger& logger,
        const StarTrackIssueData& data) const;

    mutable common::PoolHolder coreDbHolder_;
    mutable common::PoolHolder validatorDbHolder_;
    ValidationParams validationParams_;
    std::string tasksUrl_;
    st::Configuration stConfig_;
    std::string nproHost_;
};

} // namespace maps::wiki::validation_export
