#include "building_lookup.h"
#include "../include/common.h"

#include <geos/geom/Polygon.h>
#include <maps/wikimap/mapspro/services/editor/src/actions/tools/pedestrian/point_for_building.h>
#include <maps/wikimap/mapspro/services/editor/src/configs/categories_strings.h>
#include <maps/wikimap/mapspro/services/editor/src/views/objects_query.h>
#include <maps/libs/geolib/include/serialization.h>

#include <memory>

namespace maps::wiki::guide_pedestrian {

std::vector<BuildingData> loadAllBuildings(
    const geolib3::Polygon2& polygonMerc,
    common::PoolHolder& viewTrunkPoolHolder)
{
    auto viewTrunkTxnHolder = viewTrunkPoolHolder.pool().slaveTransaction();
    pqxx::transaction_base& viewTxn = viewTrunkTxnHolder.get();
    viewTxn.exec("SET search_path=vrevisions_trunk,public");

    views::ObjectsQuery objectsQuery;

    objectsQuery.addCondition(
        views::IntersectsGeometryCondition(
            viewTxn,
            common::Geom(geolib3::WKB::toString(polygonMerc))
        )
    );
    objectsQuery.addCondition(
        views::CategoriesCondition(
            viewTxn,
            StringSet{CATEGORY_BLD}
        )
    );

    auto buildingObjects = objectsQuery.exec(viewTxn, revision::TRUNK_BRANCH_ID);

    std::vector<BuildingData> retVal;
    for (const auto& viewObject : buildingObjects) {
        geolib3::Polygon2 bldPolygon = getPolygon(viewObject);

        auto bldPoint = pedestrian::pointForBuilding(bldPolygon);

        retVal.emplace_back(BuildingData{
            viewObject.id(),
            std::move(bldPolygon),
            std::move(bldPoint)});
    }

    return retVal;
}

} // namespace maps::wiki::guide_pedestrian
