#include "../include/common.h"

#include <maps/libs/enum_io/include/enum_io.h>
#include <geos/geom/Polygon.h>

namespace maps::wiki::guide_pedestrian {

namespace {

const enum_io::Representations<TaskType>
    PREDEFINED_TASK_TYPE_STRINGS {
    {TaskType::Addresses, "addresses"},
    {TaskType::Entrances, "entrances"}
};

} // unnamed namespace

DEFINE_ENUM_IO(TaskType, PREDEFINED_TASK_TYPE_STRINGS);

geolib3::Polygon2 getPolygon(const views::ViewObject& viewObject)
{
    std::unique_ptr<geos::geom::Geometry> objectGeom(
        viewObject.geom().geosGeometryPtr()->clone()
    );
    ASSERT(dynamic_cast<geos::geom::Polygon*>(objectGeom.get()));
    geolib3::Polygon2 polygon(
        std::unique_ptr<geos::geom::Polygon>(
            dynamic_cast<geos::geom::Polygon*>(objectGeom.release())
        ),
        geolib3::Validate::Yes
    );

    return polygon;
}

} // namespace maps::wiki::guide_pedestrian
