#pragma once

#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/geolib/include/polygon.h>

#include <string>
#include <vector>
#include <optional>


namespace maps::wiki::guide_pedestrian {


struct AddressTask
{
    maps::chrono::TimePoint timePoint;
    double lon;
    double lat;
    std::string buildingId;
    std::string taskId;
    geolib3::Polygon2 polygonMerc;
};

using AddressTasks = std::vector<AddressTask>;

void enqueueAddressTasks(
    const AddressTasks& addressTasks,
    const std::string& ytProxy,
    const std::string& ytPath);

struct EntranceTask
{
    maps::chrono::TimePoint timePoint;
    double lon;
    double lat;
    std::string buildingId;
    std::string taskId;
    std::optional<std::string> address;
    geolib3::Polygon2 polygonMerc;
};


using EntranceTasks = std::vector<EntranceTask>;

void enqueueEntranceTasks(
    const EntranceTasks& entranceTasks,
    const std::string& ytProxy,
    const std::string& ytPath);

} // namespace maps::wiki::guide_pedestrian
