#pragma once

#include <yandex/maps/wiki/common/extended_xml_doc.h>
#include <yandex/maps/wiki/common/pgpool3_helpers.h>
#include <yandex/maps/wiki/social/feedback/enums.h>
#include <yandex/maps/wiki/revision/common.h>
#include <maps/tools/grinder/worker/include/api.h>

namespace maps::wiki::import_feedback {

class TaskParams
{
public:
    TaskParams(
        revision::DBID dbTaskId,
        std::string source,
        social::feedback::Type type,
        social::feedback::Workflow workflow,
        bool hidden,
        std::string data);

    static TaskParams fromTxn(
        pqxx::transaction_base& txnCore,
        revision::DBID dbTaskId);

    revision::DBID dbTaskId() const;
    std::string source() const;
    social::feedback::Type type() const;
    social::feedback::Workflow workflow() const;
    bool hidden() const;
    std::string data() const;

private:
    revision::DBID dbTaskId_;
    std::string source_;
    social::feedback::Type type_;
    social::feedback::Workflow workflow_;
    bool hidden_;
    std::string data_;
};

// exposed for test purposes only
size_t importRoutine(
    const TaskParams& taskParams,
    pqxx::transaction_base& txnSocial);

// exposed for test purposes only
void cleanupOldFiles(pqxx::transaction_base& txnSocial);

class Worker
{
public:
    explicit Worker(std::unique_ptr<maps::wiki::common::ExtendedXmlDoc> cfg);

    void doTask(const grinder::worker::Task& task);

private:
    std::unique_ptr<maps::wiki::common::ExtendedXmlDoc> cfg_;
};


} // namespace maps::wiki::import_feedback
