Таска: https://st.yandex-team.ru/NMAPS-11901

Воркер импортирует indoor-фидбек, созданный толокерами из динамической [таблички на YT](https://yt.yandex-team.ru/hahn/navigation?path=//home/offline_data/walkers/maps/indoor/assignments_export). Поля таблички описаны [тут](https://st.yandex-team.ru/CROWD-635#5f4cd7ad4e28d6107490c04c).

**TLDR**:

+ уровень индора лежит в колонке `level`
+ POI-фидбечины имеют `type = Point`
+ фидбечины со стенами имеют `type = LineString`
  + стены для удаления имеют `color = red`
  + стены для добавления имеют `color = green`
  + все новые стены объединяются в одну фидбечину на этаж индора
+ новые фидбечины для одного ТЦ выгружаются одновременно с одинаковым значением `timestamp`

# Работа вокера

Раз в день вокер запускается и импортирует в НК фидбечины, добавленные в табличку за предыдущий день. Тогда образом дупликация фидбечин невозможна.

Фидбечины забираются из таблички с помощью YT c++ api.

Фидбечины заливаются в НК с помощью ручки [POST /feedback/tasks](https://a.yandex-team.ru/arc/trunk/arcadia/maps/wikimap/mapspro/services/social/lib/feedback/tasks_api.cpp?rev=7534679#L1198).

## Импорт POI

Точечные фидбечины импортируются ([как указано в таске](https://st.yandex-team.ru/NMAPS-11901)) со значением `source = sprav-pedestrian-indoor-poi`.

В кроме уровня в индоре и координат из таблички берётся комментарий толокера для отображения в карточке фидбечины.
Тело пост запроса выглядит следующим образом:
```python
    body_fmt = '''{{
        "type": "poi",
        "source": "sprav-pedestrian-indoor-poi",
        "description": "Indoor толокеры. Этаж: {level}. Комментарий: {title}",
        "workflow": "task",
        "position": {{
            "type": "Point",
            "coordinates": [
                {lon},{lat}
            ]
        }},
        "hidden": false,
        "indoorLevel": "{level}"
    }}'''
```

Пример загрузки POI можно посмотреть во [вспомагательном скрипте](https://a.yandex-team.ru/arc/trunk/arcadia/junk/efrolov89/tasks/NMAPS-11901_onfoot_indoor_poi_feedback/src/main.py?rev=7572072#L38), который использовался для ручной загрузки данных.

## Импорт стен

Линейные фидбечины импортируются ([как указано в таске](https://st.yandex-team.ru/NMAPS-11901)) со значением `source = sprav-pedestrian-indoor-walls`.

Одна строчка в таблице соответствует одной стене (линии), задаваемой набором точек в колонке `coordinates`.

Часть линейных фидбечин относится к стенам, которые нужно удалить (`color = red`), часть - к стенам, которые нужно добавить (`color = green`). 
Иногда толокеры и вовсе используют возможность передать линии, чтобы нарисовать что-то поясняющее на карте ([ссылка на пример](https://n.maps.yandex.ru/#!/feedback/tasks/10270027?indoor=3740455536&z=20&ll=50.173552%2C53.141479&l=nk%23map)).

Пример таких фидбечин можно посмотреть [тут](https://a.yandex-team.ru/arc/trunk/arcadia/junk/efrolov89/tasks/NMAPS-11901_onfoot_indoor_walls_feedback/data/tasks.json?rev=7575638).

Пример данных для стен можно посмотреть [тут](https://a.yandex-team.ru/arc/trunk/arcadia/junk/efrolov89/tasks/NMAPS-11901_onfoot_indoor_walls_feedback/data/walls_data_from_yt.json?rev=7575638).

## Разбивка по этажам ТЦ

Для каждого ТЦ для каждого этажа нужно создать одну фидбечину с новыми линиями от толокеров в этом ТЦ, на этом этаже ([пример](https://n.maps.yandex.ru/#!/feedback/tasks/10270027?indoor=3740455536&z=20&ll=50.173552%2C53.141479&l=nk%23map)).

Никакой информации о том, к какому ТЦ относится данная стена в YT-табличке нету. Её можно получить, используя функцию pullPointTowardsBld ([как в тут](https://a.yandex-team.ru/arc/trunk/arcadia/junk/efrolov89/scratches/point_to_bld/main.cpp?rev=7575638#L35)).

### Алгоритм разделения по этажам
Будем считать, что стена попадает в индор, если центр её `BoundingBox`'а попадает в индор (+300 метров буффера). Если 2 индора близко, берётся ближайший.

```
1. Для каждой стены получить objectId indoor'а (получаем отображение этаж -> множество стен)
2. Для каждого этажа:
   2. объединить все стены в одну фидбечину
```
Если по какой-то причине для стены не удалось найти индор - она будет сгруппирована с другими такими стенами по значениям `timestamp` и `level`.

Группировка по таймстемпу позволит сгруппировать стены только из данного ТЦ. Вернее стены, внесённые толокером в рамках одного задания, и, следовательно, загруженные на Ыть с одним таймстемпом.  
А группировка внутри группы с одним таймстемпом ещё и по уровню создаёт отдельные фидбечины включающие несколько стен для этажей.

```
1. Стены, для которых не получилось найти objectId indoor'а (например, нет вблизи индора почему-то) группируем по `timestamp`
2. Для каждой группы стен с одним `timestamp` группируем стены по `level`.
3. Все стены с одним `timestamp` и `level` собираем в одну фидбечину.
```

### Алгоритм объединения стен в одну фидбечину для этажа

```
Если color == red
    Добавляем полилинию в удаляемые линии
Если color == green
    Добавляем полилинию в добавляемые линии
Добавляем уровень внутри здания из поля level
Высчитываем позицию фидбечины
Высчитываем границы экрана для фидбечины
Создаём description фидбечины в виде: "Indoor толокеры. Этаж: {indoor_level}. (удалить - красные линии, добавить - бирюзовые линии)"
```

