#include <maps/wikimap/mapspro/services/tasks_feedback/src/import_indoor_feedback_worker/lib/to_tasks.h>

#include <maps/wikimap/mapspro/libs/misc_point_to_indoor/include/point_to_indoor.h>
#include <maps/wikimap/mapspro/services/tasks_feedback/src/import_indoor_feedback_worker/lib/to_task.h>
#include <maps/libs/geolib/include/conversion.h>
#include <maps/libs/geolib/include/point.h>
#include <maps/libs/geolib/include/polyline.h>
#include <yandex/maps/wiki/revision/common.h>

#include <algorithm>
#include <unordered_map>

namespace maps::wiki::tasks_feedback::indoor_feedback {

using social::feedback::TaskNew;
using geolib3::Polyline2;
using geolib3::Point2;
using Walls = std::vector<Wall>;

namespace {

std::optional<revision::DBID> findIndoor(
    pqxx::transaction_base& viewTrunkTxn,
    const geolib3::Point2& mercPoint,
    const std::string& universalIndoorLevelId)
{
    viewTrunkTxn.exec("SET search_path=vrevisions_trunk,public");
    return misc::getIndoorObjectId(
        viewTrunkTxn,
        0, // trunk branch id
        mercPoint,
        300.0, // search radius in meters
        universalIndoorLevelId);
}

Point2 getMercatorPoint(const Wall& wall)
{
    const auto bboxCenter = Polyline2(wall.points).boundingBox().center();
    return geolib3::geoPoint2Mercator(bboxCenter);
}


template<class Key>
void appendWallsValuesToVector(
    std::unordered_map<Key, Walls>&& wallsByKey,
    std::vector<Walls>& output)
{
    output.reserve(output.size() + wallsByKey.size());
    for (auto& [key, walls]: wallsByKey) {
        output.emplace_back(std::move(walls));
    }
}

std::unordered_map<std::string, Walls> groupByLevel(const Walls& walls)
{
    std::unordered_map<std::string, Walls> wallsByIndoorLevel;
    for (const auto& wall: walls) {
        wallsByIndoorLevel[wall.indoorLevel].push_back(wall);
    }
    return wallsByIndoorLevel;
}

std::vector<Walls> groupWalls(
    pqxx::transaction_base& coreTxn,
    const Walls& walls)
{
    std::unordered_map<revision::DBID, Walls> wallsByIndoorId;
    std::unordered_map<uint64_t, Walls> wallsByTimestamp;

    for (const auto& wall: walls) {
        const auto indoorId = findIndoor(
            coreTxn,
            getMercatorPoint(wall),
            wall.indoorLevel);
        if (indoorId.has_value()) {
            wallsByIndoorId[indoorId.value()].emplace_back(wall);
        } else {
            wallsByTimestamp[wall.timestamp].emplace_back(wall);
        }
    }

    std::vector<Walls> retVal;
    appendWallsValuesToVector(std::move(wallsByIndoorId), retVal);
    for (const auto& [timestamp, walls]: wallsByTimestamp) {
        auto wallsByLevel = groupByLevel(walls);
        appendWallsValuesToVector(std::move(wallsByLevel), retVal);
    }

    return retVal;
}

} // namespace

std::vector<TaskNew> toTasks(
    pqxx::transaction_base& viewTrunkTxn,
    YTData&& ytData)
{
    const auto wallsGroups = groupWalls(viewTrunkTxn, std::move(ytData.walls));
    std::vector<TaskNew> retVal;
    retVal.reserve(wallsGroups.size() + ytData.pois.size());

    for (const auto& walls: wallsGroups) {
        retVal.emplace_back(toTask(walls));
    }
    for (const auto& poi: ytData.pois) {
        retVal.emplace_back(toTask(poi));
    }
    return retVal;
}
    

} // namespace maps::wiki::tasks_feedback::indoor_feedback                      
