#include <maps/wikimap/mapspro/services/tasks_feedback/src/import_indoor_feedback_worker/lib/poi.h>
#include <maps/wikimap/mapspro/services/tasks_feedback/src/import_indoor_feedback_worker/lib/to_task.h>

#include <library/cpp/testing/unittest/registar.h>

#include <maps/libs/log8/include/log8.h>
#include <maps/libs/geolib/include/conversion.h>
#include <maps/libs/geolib/include/point.h>
#include <maps/libs/geolib/include/polyline.h>
#include <yandex/maps/wiki/social/feedback/task_new.h>
#include <maps/libs/json/include/builder.h>


namespace maps::wiki::tasks_feedback::indoor_feedback::test {

namespace sf = maps::wiki::social::feedback;
using sf::TaskNew;
using geolib3::Point2;
using geolib3::Polyline2;

Y_UNIT_TEST_SUITE(indoor_pois_and_walls_to_tasks) {

Y_UNIT_TEST(poi_to_task_test)
{
    const Point2 position = Point2(1.1, 2.2);
    const std::string title = "some user comment";
    const std::string indoorLevel = "abc";

    Poi poi{
        indoorLevel,
        position,
        title
    };
    const auto taskNew = toTask(poi);
    UNIT_ASSERT_EQUAL(
        taskNew.description,
        "Indoor толокеры. Этаж: " + indoorLevel + ". Комментарий: " + title);
    UNIT_ASSERT_EQUAL(taskNew.type, sf::Type::Poi);
    UNIT_ASSERT_EQUAL(taskNew.position, geolib3::geoPoint2Mercator(position));
    UNIT_ASSERT_EQUAL(taskNew.indoorLevel, indoorLevel);
    UNIT_ASSERT_EQUAL(taskNew.source, "sprav-pedestrian-indoor-poi");
} // Y_UNIT_TEST

Y_UNIT_TEST(walls_to_task_test)
{
    const uint64_t someTimeStamp = 42;
    const std::string indoorLevel = "abc";
        
    Wall redWall{
        someTimeStamp,
        indoorLevel,
        {Point2(-5.5, -1.0), Point2(0.0, 0.0)},
        Wall::Color::Red};
    Wall greenWallInsideBbox{
        someTimeStamp,
        indoorLevel,
        {
            Point2(5.5, 1.0),
            Point2(5.3, 1.0),
            Point2(5.2, 1.0),
            Point2(0.0, 0.0)
        },
        Wall::Color::Green};
    Wall greenWallOnTheEdgeOfBbox{
        someTimeStamp,
        indoorLevel,
        {
            Point2(15.0, 10.0),
            Point2(10.0, 10.0)
        },
        Wall::Color::Green};

    const auto taskNew = toTask({
            redWall,
            greenWallOnTheEdgeOfBbox,
            greenWallInsideBbox
        });

    UNIT_ASSERT_EQUAL(
        taskNew.description,
        "Indoor толокеры. Этаж: " + indoorLevel +
            ". (удалить - красные линии, добавить - бирюзовые линии)"
    );
    UNIT_ASSERT_EQUAL(taskNew.type, sf::Type::Poi);
    UNIT_ASSERT_EQUAL(
        taskNew.position,
        geolib3::geoPoint2Mercator(Point2(4.75, 4.5)));
    UNIT_ASSERT_EQUAL(taskNew.indoorLevel, indoorLevel);
    UNIT_ASSERT_EQUAL(taskNew.source, "sprav-pedestrian-indoor-walls");
    UNIT_ASSERT(taskNew.attrs.exist(sf::AttrType::ObjectDiff));
} // Y_UNIT_TEST

} // Y_UNIT_TEST_SUITE

} // namespace maps::wiki::tasks_feedback::indoor_feedback::test
