#include <maps/libs/cmdline/include/cmdline.h>
#include <maps/libs/log8/include/log8.h>

#include <maps/wikimap/mapspro/services/tasks_feedback/src/matview_refresher_worker/lib/worker.h>

#include <yandex/maps/wiki/common/default_config.h>
#include <yandex/maps/wiki/common/extended_xml_doc.h>
#include <yandex/maps/wiki/common/pgpool3_helpers.h>

#include <memory>

namespace {

const std::string MODULE_NAME = "wiki-matview-refresher-worker";

} // anonymous namespace

int main(int argc, char* argv[]) try
{
    maps::cmdline::Parser parser;
    auto workerConfig = parser.string("config")
            .help("path to worker configuration");
    auto syslogTag = parser.string("syslog-tag")
            .help("redirect log output to syslog with given tag");
    auto statusDir = parser.string("status-dir")
            .help("path to status dir");

    parser.parse(argc, argv);

    if (syslogTag.defined()) {
        maps::log8::setBackend(maps::log8::toSyslog(syslogTag));
    }

    auto configXml = workerConfig.defined()
        ? std::make_unique<maps::wiki::common::ExtendedXmlDoc>(workerConfig)
        : maps::wiki::common::loadDefaultConfig();

    maps::wiki::common::PoolHolder socialPool(*configXml, "social", "grinder");
    maps::wiki::tasks::StatusWriter statusWriter(std::nullopt);
    if (statusDir.defined()) {
        statusWriter.reinit(statusDir, MODULE_NAME + ".status");
    }
    maps::wiki::matview_refresher::Worker worker(
        socialPool.pool(),
        statusWriter
    );

    INFO() << "matview-refresher-worker started";
    worker.doTask();
    return EXIT_SUCCESS;
} catch (const maps::Exception& e) {
    FATAL() << "Worker failed: " << e;
    return EXIT_FAILURE;
} catch (const std::exception& e) {
    FATAL() << "Worker failed: " << e.what();
    return EXIT_FAILURE;
}
