#include <maps/wikimap/mapspro/services/tasks_feedback/src/matview_refresher_worker/lib/worker.h>
#include <maps/wikimap/mapspro/services/tasks_feedback/src/matview_refresher_worker/tests/fixtures.h>

#include <yandex/maps/wiki/common/aoi.h>
#include <yandex/maps/wiki/common/robot.h>

#include <yandex/maps/wiki/social/feedback/gateway_rw.h>
#include <yandex/maps/wiki/social/feedback/mv_source_type.h>

#include <yandex/maps/wiki/unittest/arcadia.h>

namespace maps::wiki::matview_refresher::tests {

namespace sf = social::feedback;

namespace {

const social::TUid USER_ID = 1;

const std::string SOME_SOURCE = "some-source";
const auto SOME_TYPE = sf::Type::Barrier;

auto SOME_DESCR()
{
    return sf::Description("some-description");
}

} // anonymous

Y_UNIT_TEST_SUITE(worker_tests) {

Y_UNIT_TEST_F(refresh_mat_view, DBFixture)
{
    {
        // Adding one outgoing row to table
        //
        auto socialWriteTxn = pool().masterWriteableTransaction();
        sf::GatewayRW gatewayRw(socialWriteTxn.get());
        auto taskId = gatewayRw.addTask(
            USER_ID,
            sf::TaskNew(
                geolib3::Point2(0, 0),
                SOME_TYPE,
                SOME_SOURCE,
                SOME_DESCR()
            )
        ).id();

        gatewayRw.updateTaskById(
            taskId,
            sf::TaskPatch(common::ROBOT_UID).setBucket(sf::Bucket::Outgoing)
        );

        socialWriteTxn->commit();
    }

    {
        // Running whole worker cycle and calling refreshing mat view
        //
        tasks::StatusWriter statusWriter(std::nullopt);
        Worker worker(pool(), statusWriter);
        worker.doTask();
    }

    {
        // Check resulting mat view
        //
        auto sociaReadTxn = pool().masterReadOnlyTransaction();

        auto sources = sf::mvSourcesByFilter(sociaReadTxn.get(), {});

        UNIT_ASSERT(sources.size() == 1);
        UNIT_ASSERT_STRINGS_EQUAL(*sources.begin(), SOME_SOURCE);

        auto types = sf::mvTypesByFilter(sociaReadTxn.get(), {});

        UNIT_ASSERT(types.size() == 1);
        UNIT_ASSERT_EQUAL(types.front(), SOME_TYPE);
    }
}

} // Y_UNIT_TEST_SUITE(worker_tests)

} // namespace maps::wiki::matview_refresher::tests
