#include "parsed_message.h"

#include <maps/libs/json/include/builder.h>

namespace maps::wiki::notifications_sender {

namespace {

const std::string MAIL_TYPE = "mail-type";
const std::string PUID = "puid";
const std::string ARGS = "args";

std::string toString(const json::Value& jsonVal)
{
    json::Builder builder;
    builder << jsonVal;
    return builder.str();
}

} // unnamed namespace

std::string toString(const ParsedMessage& message)
{
    return
        PUID + "=" + std::to_string(message.puid) + "," +
        MAIL_TYPE + "=" + message.mailType + "," +
        ARGS + "=" + toString(message.args);
}

ParsedMessage parseMessage(const Aws::SQS::Model::Message& sqsMessage)
{
    auto messageJson = json::Value::fromString(sqsMessage.GetBody());

    return ParsedMessage {
        messageJson[PUID].as<social::TUid>(),
        messageJson[MAIL_TYPE].as<std::string>(),
        messageJson[ARGS]
    };
}

} // namespace maps::wiki::notifications_sender
