#pragma once

#include <yandex/maps/wiki/social/common.h>
#include <maps/libs/json/include/value.h>

#include <aws/sqs/SQSClient.h>

namespace maps::wiki::notifications_sender {

struct ParsedMessage
{
    social::TUid puid;
    std::string mailType;
    json::Value args;
};

std::string toString(const ParsedMessage& message);

ParsedMessage parseMessage(const Aws::SQS::Model::Message& sqsMessage);

} // namespace maps::wiki::notifications_sender
