#pragma once

#include "parsed_message.h"
#include "user_mail_info.h"

#include <maps/wikimap/mapspro/libs/sender/include/campaigns.h>
#include <maps/wikimap/mapspro/libs/sender/include/email_template_params.h>

namespace maps::wiki::notifications_sender {

struct NotExistingCampaignError : RuntimeError
{
    NotExistingCampaignError(const ParsedMessage& message);
    NotExistingCampaignError(const ParsedMessage& message, const UserMailInfo& userInfo);
};


class SenderMailing
{
public:
    SenderMailing(const sender::CampaignsSlugs& campaigns);

    bool isSuitableCampaignSlugExist(
        const ParsedMessage& message, const UserMailInfo& userInfo) const;

    sender::CampaignSlug getCampaignSlug(
        const ParsedMessage& message, const UserMailInfo& userInfo) const;

    sender::EmailTemplateParams getEmailParams(
        const ParsedMessage& message, const UserMailInfo& userInfo) const;

private:
    const std::string& getCampaignName(const ParsedMessage& message) const;

    std::optional<sender::CampaignSlug> getCampaignSlugNoThrow(
        const ParsedMessage& message, const UserMailInfo& userInfo) const;

private:
    const sender::CampaignsSlugs& campaigns_;
};

} // namespace maps::wiki::notifications_sender
