#pragma once

#include <yandex/maps/wiki/http/blackbox/blackbox.h>
#include <yandex/maps/wiki/social/profile_gateway.h>
#include <optional>

namespace maps::wiki::notifications_sender {


class UserMailInfo
{
public:
    UserMailInfo(
        social::TUid puid,
        std::string email,
        std::string userName,
        std::string locale);

    social::TUid puid() const;
    const std::string& userName() const;
    const std::string& email() const;
    const std::string& locale() const;

private:
    social::TUid puid_;
    std::string email_;
    std::string userName_;
    std::string locale_;
};


class UserMailInfoProvider {
public:
    UserMailInfoProvider(
        const social::IProfileGateway& socialProfileGtw,
        const blackbox::IGateway& blackboxGtw);

    std::optional<UserMailInfo> getUserMailInfo(social::TUid puid);

private:
    const social::IProfileGateway& socialProfileGtw_;
    const blackbox::IGateway& blackboxGtw_;
};

} // namespace maps::wiki::notifications_sender
