#pragma once

#include "parsed_message.h"

#include <yandex/maps/wiki/http/blackbox/blackbox.h>
#include <yandex/maps/wiki/common/extended_xml_doc.h>
#include <yandex/maps/wiki/common/pgpool3_helpers.h>

#include <maps/wikimap/mapspro/libs/sender/include/config.h>
#include <maps/wikimap/mapspro/libs/sqs_client/include/configuration.h>
#include <maps/wikimap/mapspro/libs/sqs_client/include/client.h>

#include <library/cpp/tvmauth/client/facade.h>

namespace maps::wiki::notifications_sender {

class Worker
{
public:
    explicit Worker(
        const common::ExtendedXmlDoc& servicesConfig,
        const sender::Config& senderConfig);

    void doCycleNoExcept();
    void doCycle();
    void processRawMessage(const Aws::SQS::Model::Message& sqsMessage);
    void addToNotificationsStorage(const ParsedMessage& parsedMessage);

private:
    sender::Config senderConfig_;
    common::PoolHolder socialDbPoolHolder_;
    sqs::Configuration sqsConfig_;
    Aws::SQS::SQSClient sqsClient_;
    NTvmAuth::TTvmClient tvmClient_;
    blackbox::Gateway blackboxClient_;
};

} // namespace maps::wiki::notifications_sender
