#include <maps/wikimap/mapspro/services/tasks_feedback/src/reject_feedback_worker/lib/worker.h>

#include <maps/libs/cmdline/include/cmdline.h>
#include <maps/libs/log8/include/log8.h>
#include <maps/libs/mongo/include/init.h>
#include <maps/tools/grinder/worker/include/api.h>
#include <yandex/maps/wiki/common/default_config.h>
#include <yandex/maps/wiki/common/extended_xml_doc.h>

#include <memory>

namespace mgw = maps::grinder::worker;
namespace mwtr = maps::wiki::tasks_feedback::reject_fb;

namespace {

constexpr size_t WORKER_CONCURRENCY = 1;
const std::string TASK_NAME = "reject_feedback";

} // anonymous namespace


int main(int argc, char* argv[]) try
{
    maps::cmdline::Parser parser;
    auto workerConfig = parser.string("config")
            .help("path to worker configuration");
    auto syslogTag = parser.string("syslog-tag")
            .help("redirect log output to syslog with given tag");
    auto grinderConfig = parser.string("grinder-config")
            .help("path to grinder configuration file");

    parser.parse(argc, argv);

    if (syslogTag.defined()) {
        maps::log8::setBackend(maps::log8::toSyslog(syslogTag));
    }

    maps::mongo::init();

    auto configXml = workerConfig.defined()
        ? std::make_unique<maps::wiki::common::ExtendedXmlDoc>(workerConfig)
        : maps::wiki::common::loadDefaultConfig();

    mgw::Options workerOpts;

    if (grinderConfig.defined()) {
        workerOpts.setConfigLocation(grinderConfig);
    }

    mwtr::Worker worker(std::move(configXml));

    INFO() << "reject-feedback-worker started";

    workerOpts.on(
        TASK_NAME,
        [&](const mgw::Task& task) {
            worker.doTask(task);
        }
    ).setConcurrencyLevel(WORKER_CONCURRENCY);

    mgw::run(std::move(workerOpts));

    return EXIT_SUCCESS;
} catch (const maps::Exception& e) {
    FATAL() << "Worker failed: " << e;
    return EXIT_FAILURE;
} catch (const std::exception& e) {
    FATAL() << "Worker failed: " << e.what();
    return EXIT_FAILURE;
}
