#pragma once

#include <maps/tools/grinder/worker/include/api.h>

#include <maps/libs/geolib/include/polygon.h>
#include <yandex/maps/wiki/common/extended_xml_doc.h>
#include <yandex/maps/wiki/common/pgpool3_helpers.h>
#include <yandex/maps/wiki/revision/common.h>
#include <yandex/maps/wiki/social/common.h>
#include <yandex/maps/wiki/social/feedback/enums.h>

#include <pqxx/pqxx>
#include <vector>

namespace maps::wiki::tasks_feedback::reject_fb {

class TaskParams
{
public:
    TaskParams(
        revision::DBID dbTaskId,
        geolib3::Polygon2 polygon,
        std::vector<social::feedback::Workflow> workflows,
        std::vector<std::string> sources,
        std::vector<social::feedback::Type> types,
        social::feedback::RejectReason reason);

    static TaskParams fromTxn(
        pqxx::transaction_base& txnCore,
        revision::DBID dbTaskId);

    revision::DBID dbTaskId() const { return dbTaskId_; }
    const geolib3::Polygon2& polygon() const { return polygon_; }
    const std::vector<social::feedback::Workflow>& workflows() const { return workflows_; }
    const std::vector<std::string>& sources() const { return sources_; }
    const std::vector<social::feedback::Type>& types() const { return types_; }
    social::feedback::RejectReason rejectReason() const { return rejectReason_; }

    static size_t batchSize() { return 1000; }

private:
    revision::DBID dbTaskId_;
    geolib3::Polygon2 polygon_;
    std::vector<social::feedback::Workflow> workflows_;
    std::vector<std::string> sources_;
    std::vector<social::feedback::Type> types_;
    social::feedback::RejectReason rejectReason_;
};

class Worker
{
public:
    explicit Worker(std::unique_ptr<maps::wiki::common::ExtendedXmlDoc> cfg);

    void doTask(const grinder::worker::Task& task);

private:
    std::unique_ptr<maps::wiki::common::ExtendedXmlDoc> cfg_;
};


namespace impl {

[[nodiscard]] social::TIds
rejectTasks(pqxx::transaction_base& socialTxn, const TaskParams& params);

void saveRejectedTaskIds(
    revision::DBID dbTaskId,
    const social::TIds& rejectedTaskIds,
    pqxx::transaction_base& coreTxn,
    size_t batchSize);

} // namespace impl

} // namespace maps::wiki::tasks_feedback::reject_fb
