#pragma once

#include "common.h"

#include <maps/libs/chrono/include/time_point.h>
#include <maps/wikimap/mapspro/libs/sender/include/config.h>
#include <maps/wikimap/mapspro/libs/sender/include/email_template_params.h>
#include <maps/wikimap/mapspro/libs/sender/include/gateway.h>
#include <yandex/maps/wiki/common/extended_xml_doc.h>

namespace maps::wiki::releases_notification {

namespace template_param_names {

// common
const std::string USERNAME = "username";
const std::string BLOG_URL = "blog_url";
const std::string CLUB_URL = "club_url";
const std::string MAPS_URL = "maps_url";
const std::string NMAPS_URL = "nmaps_url";
const std::string FEEDBACK_URL = "feedback_url";
const std::string UNSUBSCRIBE_URL = "unsubscribe_url";

// vec specific
const std::string SINCE_DATE_PREFIX = "since_";
const std::string TILL_DATE_PREFIX = "till_";
const std::string CORRECTIONS_COUNT = "corrections_count";
const std::string SHARE_TITLE_TEXT = "share_title_text";
const std::string SHARE_DESCRIPTION_TEXT = "share_description_text";

// survey and event specific
const std::string SUBJECT = "subject";

// event specific
const std::string EVENT_NAME = "event_name";

} // namespace template_param_names


/**
 * Keep date (day, month, year) as strings in right locale
 */
class SimpleDate
{
public:
    static SimpleDate fromTimePoint(chrono::TimePoint tp, const locale::Locale& locale);

    std::string day;
    std::string month;
    std::string year;
};

void addDateParam(sender::EmailTemplateParams& params, const std::string& prefix, const SimpleDate& date);

class ITypeSpecificParams
{
public:
    virtual sender::EmailTemplateParams toEmailParams(const locale::Locale& locale) const = 0;

    virtual ~ITypeSpecificParams() = default;
};

class VecParams: public ITypeSpecificParams
{
public:
    VecParams(
        size_t commitsCount,
        chrono::TimePoint sinceTimePoint,
        chrono::TimePoint tillTimePoint);

    sender::EmailTemplateParams toEmailParams(const locale::Locale& locale) const override;

private:
    size_t commitsCount_;
    chrono::TimePoint sinceTimePoint_;
    chrono::TimePoint tillTimePoint_;
};

class EmptyParams: public ITypeSpecificParams
{
public:
    sender::EmailTemplateParams toEmailParams(const locale::Locale& /*locale*/) const override
    {
        return sender::EmailTemplateParams();
    }
};

class ConstParams: public ITypeSpecificParams
{
public:
    ConstParams(std::map<std::string, std::string> nameToValue)
        : nameToValue_(std::move(nameToValue))
    {}

    sender::EmailTemplateParams toEmailParams(const locale::Locale& /*locale*/) const override
    {
        return sender::EmailTemplateParams::fromDict(nameToValue_);
    }

private:
    std::map<std::string, std::string> nameToValue_;
};


sender::EmailTemplateParams
renderEmailParams(
    const ITypeSpecificParams& typeSpecificParams,
    const UserInfo& userInfo,
    const sender::ConstantParams& senderConstants,
    const TaskParams& taskParams);

sender::EmailTemplateParams
renderEmailParamsForTestUser(
    const ITypeSpecificParams& typeSpecificParams,
    const sender::ConstantParams& senderConstants,
    const TaskParams& taskParams);


} // maps::wiki::releases_notification

