#pragma once

#include "common.h"

#include <yandex/maps/wiki/http/blackbox/blackbox.h>
#include <yandex/maps/wiki/common/extended_xml_doc.h>
#include <yandex/maps/wiki/tasks/task_logger.h>
#include <yandex/maps/wiki/revision/common.h>
#include <yandex/maps/wiki/revision/commit.h>
#include <maps/wikimap/mapspro/libs/acl/include/aclgateway.h>
#include <yandex/maps/wiki/social/profile_gateway.h>

#include <maps/wikimap/mapspro/libs/sender/include/campaigns.h>
#include <maps/wikimap/mapspro/libs/sender/include/config.h>
#include <maps/wikimap/mapspro/libs/sender/include/gateway.h>

#include <chrono>
#include <optional>

namespace maps::wiki::releases_notification {

class UserFilter
{
public:
    UserFilter(
        std::unique_ptr<blackbox::IGateway> blackbox,
        pqxx::transaction_base& txnCore,
        pqxx::transaction_base& txnSocial);

    std::optional<UserInfo> checkAndGetSocialInfo(maps::wiki::revision::UserID uid);

private:
    std::unique_ptr<blackbox::IGateway> blackbox_;
    acl::ACLGateway aclGateway_;
    social::ProfileGateway socialProfileGateway_;
};


// find email addresses to send notification on
// and save them and their params to DB
void collectEmailsForNotification(
    const common::ExtendedXmlDoc& servicesConfig,
    const sender::Config& senderConfig,
    const TaskParams& params,
    PgPools& pgPools,
    tasks::TaskPgLogger& logger);

// fetch emails with params from DB
// perform sending
void notifyUsers(
    PgPools& pgPools,
    revision::DBID taskId,
    sender::BaseGateway& senderGateway,
    const sender::LocalizedCampaign& localizedCampaign,
    tasks::TaskPgLogger& logger);

} // maps::wiki::releases_notification
