#pragma once

#include <util/generic/string.h>

namespace maps::wiki::route_lost_feedback::column_names {

const TString KEY = "lost_key";
const TString LOSTS_NUMBER = "route_losts_number";
const TString PERSISTENT_ID = "persistent_id";
const TString SEGMENT_INDEX = "segment_index";
const TString TRACKS_NUMBER = "tracks_number";
const TString INVERTED_SCORE = "inverted_score";
const TString LOST_POINT = "lost_point";

const TString BEFORE_LOST_SEGMENT = "before_lost_segment";
const TString AFTER_LOST_ROUTE_SEGMENT = "after_lost_route_segment";
const TString AFTER_LOST_TRACK_SEGMENT = "after_lost_track_segment";
const TString AFTER_AFTER_LOST_TRACK_SEGMENT = "after_after_lost_track_segment";

const TString POINTS_BEFORE_LOST = "points_before_lost";
const TString POINTS_ROUTE_AFTER_LOST = "points_route_after_lost";
const TString POINTS_TRACK_AFTER_LOST = "points_track_after_lost";

const TString ROUTE_GEOMETRY = "route_geometry";
const TString TRACK_GEOMETRY = "track_geometry";
const TString TRACK_PERSISTENT_SEGMENTS = "track_persistent_segments";
const TString ROUTE_PERSISTENT_SEGMENTS = "route_persistent_segments";
const TString ROUTE_LOST_POSITION = "route_lost_position";
const TString ROUTE_LOST_TYPE = "route_lost_type";
const TString TYPE = "type";
const TString ROUTE = "route";
const TString TRACK = "track";
const TString ROUTE_ID = "route_id";
const TString ROUTE_START = "route_start";
const TString ROUTE_END = "route_end";

const TString START_LON = "start_lon";
const TString START_LAT = "start_lat";

} // namespace maps::wiki::route_lost_feedback::column_names
