#include "common.h"
#include <maps/libs/geolib/include/spatial_relation.h>

namespace mjs = maps::jams::static_graph2;

namespace maps::wiki::route_lost_feedback {

mjs::PersistentSegmentId
asPersistentSegment(const NYT::TNode& segment)
{
    const NYT::TNode::TListType& segmentIds = segment.AsList();

    return mjs::PersistentSegmentId(
        mjs::LongId(segmentIds.at(0).AsUint64()),
        segmentIds.at(1).AsUint64()
    );
}

geolib3::Point2
asPoint(const NYT::TNode& node)
{
    return geolib3::Point2 {
        node.AsList()[0].AsDouble(),
        node.AsList()[1].AsDouble()
    };
}

NYT::TNode
toTNode(const jams::static_graph2::PersistentSegmentId& segment)
{
    auto resNode = NYT::TNode::CreateList();
    resNode.Add(NYT::TNode(segment.edgeId().value()));
    resNode.Add(NYT::TNode(segment.segmentIndex()));
    return resNode;
}

NYT::TNode
toTNode(const geolib3::Point2& point)
{
    auto resNode = NYT::TNode::CreateList();
    resNode.Add(NYT::TNode(point.x()));
    resNode.Add(NYT::TNode(point.y()));
    return resNode;
}

bool pointIsInsidePolygon(
    const geolib3::Point2& point,
    const geolib3::Polygon2& polygon)
{
    return geolib3::spatialRelation(
        polygon, point, geolib3::SpatialRelation::Contains);
}

} // namespace maps::wiki::route_lost_feedback

