#pragma once

#include <mapreduce/yt/interface/client.h>
#include <yandex/maps/jams/static_graph2/persistent_segment_id.h>
#include <maps/libs/geolib/include/point.h>
#include <maps/libs/geolib/include/polygon.h>

namespace maps::wiki::route_lost_feedback {

jams::static_graph2::PersistentSegmentId
asPersistentSegment(const NYT::TNode& segment);

geolib3::Point2
asPoint(const NYT::TNode& node);

NYT::TNode
toTNode(const jams::static_graph2::PersistentSegmentId& segment);

NYT::TNode
toTNode(const geolib3::Point2& point);

bool pointIsInsidePolygon(
    const geolib3::Point2& point,
    const geolib3::Polygon2& polygon);

} // namespace maps::wiki::route_lost_feedback
