#pragma once

#include <mapreduce/yt/interface/client.h>
#include <maps/libs/geolib/include/bounding_box.h>
#include <maps/libs/geolib/include/point.h>

#include <string>

namespace maps::wiki::route_lost_feedback {

class FeedbackDescriptionLinksGenerator
{
public:
    FeedbackDescriptionLinksGenerator(const NYT::TNode& ytRow);

    std::string localLink() const;
    std::string localUserLink() const;
    std::string localNaviLink() const;
    std::string globalNaviLink() const;

private:
    const std::string staticApiPrefix_ = "https://static-maps.yandex.ru/1.x/?l=map";
    const std::string blueColor_  = "000080";
    const std::string greenColor_ = "008000";
    const std::string lineWidth_ = "2";

    geolib3::PointsVector pointsBeforeLost_;
    geolib3::PointsVector pointsRouteAfterLost_;
    geolib3::PointsVector pointsTrackAfterLost_;

    geolib3::BoundingBox bboxOfTracks_;

    geolib3::Point2 routeStartPos_;
    geolib3::Point2 routeEndPos_;

private:
    std::string staticApiUrlPlusBbox() const;

    std::string
    fullTrackWithLostPointLink(
        const geolib3::PointsVector& fullTrack,
        const geolib3::Point2& lostPoint,
        const std::string& color) const;
};

} // namespace maps::wiki::route_lost_feedback
