#pragma once

#include <maps/libs/geolib/include/polygon.h>
#include <mapreduce/yt/interface/client.h>

namespace maps::wiki::route_lost_feedback {

class LostMapper : public NYT::IMapper<
    NYT::TTableReader<NYT::TNode>,
    NYT::TTableWriter<NYT::TNode>>
{
public:
    Y_SAVELOAD_JOB(polygonGeoBytes_);

    LostMapper() = default;
    LostMapper(const geolib3::Polygon2& polygonGeo);
    void Do(TReader* reader, TWriter* writer) override;

private:
    std::vector<uint8_t> polygonGeoBytes_;
};

} // namespace maps::wiki::route_lost_feedback
