#include "lost_track_reducer.h"
#include "column_names.h"

namespace maps::wiki::route_lost_feedback {

void LostTrackReducer::Do(TReader* reader, TWriter* writer)
{
    // If the first table in input is tracks table, it is guaranteed
    // that the first row will be from that table
    //
    if (reader->GetTableIndex() != 0) {
        return;
    }

    uint64_t tracksNumber =
        reader->GetRow()[column_names::TRACKS_NUMBER].AsUint64();

    reader->Next();

    // All other rows are from the route table
    //
    for (; reader->IsValid(); reader->Next()) {
        const auto& row = reader->GetRow();
        writer->AddRow(NYT::TNode(row)(column_names::TRACKS_NUMBER, tracksNumber));
    }
}

REGISTER_REDUCER(LostTrackReducer);

} // namespace maps::wiki::route_lost_feedback
