#pragma once

#include <mapreduce/yt/interface/client.h>

namespace maps::wiki::route_lost_feedback {

class ScoreMapper : public NYT::IMapper<
    NYT::TTableReader<NYT::TNode>,
    NYT::TTableWriter<NYT::TNode>>
{
public:
    Y_SAVELOAD_JOB(countDays_);

    ScoreMapper() = default;
    ScoreMapper(uint64_t countDays);

    void Do(TReader* reader, TWriter* writer) override;

private:
    uint64_t countDays_;
};

} // namespace maps::wiki::route_lost_feedback
